function draw_poly(ctx, pts, stroke='', fill='', width=1) {

    ctx.beginPath();
    let b = pts.shift();
    if (b)
        ctx.moveTo(b[0],b[1]);
    pts.forEach(p => {if (p) ctx.lineTo(p[0],p[1]);});
    ctx.closePath();
    if (stroke) {
        ctx.strokeStyle=stroke;
        ctx.lineWidth = width;
        ctx.stroke();
    }
    if (fill) {
        ctx.fillStyle = fill;
        ctx.fill();
    }
}

function draw_circle(ctx, x, y, r, stroke='', fill='', width=1) {
    ctx.beginPath();
    ctx.arc(x, y, r, 0, 2*Math.PI);
    if (stroke) {
        ctx.lineWidth = width;
        ctx.strokeStyle = stroke;
        ctx.stroke();
    }
    if (fill) {
        ctx.fillStyle = fill;
        ctx.fill();
    }
}

function draw_line(ctx, x1, y1, x2, y2, stroke='', width=1) {
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x2, y2);
    if (stroke) {
        ctx.strokeStyle = stroke;
        ctx.lineWidth = width;
        ctx.stroke();
    }
}

function r_cor(R, l) {
    // Correction to R to fit the sine-cosine crosspoints nicely
    return Math.sqrt((Math.PI/2*l)**2 + (2*R)**2)/2
}